<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Model;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

trait TypedTaxonTrait
{
    /**
     * @ORM\Column(name="type", type="string", options={"default": "default"})
     *
     * @Assert\Choice(callback="getAllowedTypes", groups="sylius")
     */
    protected string $type = 'default';

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->type = $type;

        return $this;
    }

    /** @return string[] */
    public static function getAllowedTypes(): array
    {
        return TypedTaxonInterface::ALLOWED_TYPES;
    }
}
