<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\ProductTaxonInterface;

trait ProductTaxonAwareTrait
{
    /**
     * @var Collection|ProductTaxonInterface[]
     *
     * @ORM\OneToMany(targetEntity="Sylius\Component\Core\Model\ProductTaxonInterface", mappedBy="taxon", cascade={"persist", "remove"}, orphanRemoval=true)
     */
    protected $productTaxons;

    public function __construct()
    {
        $this->productTaxons = new ArrayCollection();
    }

    public function hasProductTaxons(): bool
    {
        return $this->productTaxons->count() > 0;
    }

    public function getProductTaxons(): Collection
    {
        return $this->productTaxons;
    }

    public function hasProductTaxon(ProductTaxonInterface $productTaxon): bool
    {
        return $this->productTaxons->contains($productTaxon);
    }

    public function addProductTaxon(ProductTaxonInterface $productTaxon): void
    {
        if (!$this->hasProductTaxon($productTaxon)) {
            $productTaxon->setTaxon($this);
            $this->productTaxons->add($productTaxon);
        }
    }

    public function removeProductTaxon(ProductTaxonInterface $productTaxon): void
    {
        if ($this->hasProductTaxon($productTaxon)) {
            $productTaxon->setTaxon(null);
            $this->productTaxons->removeElement($productTaxon);
        }
    }
}
