<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping\OneToMany;

trait ProductBrandAwareTrait
{
    /**
     * @var Collection|BrandAwareInterface[]
     *
     * @OneToMany(targetEntity="Dedi\SyliusTaxonTypePlugin\Model\BrandAwareInterface", mappedBy="brand")
     */
    protected $brandProducts;

    public function __construct()
    {
        $this->brandProducts = new ArrayCollection();
    }

    public function hasBrandProducts(): bool
    {
        return $this->brandProducts->count() > 0;
    }

    public function getBrandProducts(): Collection
    {
        return $this->brandProducts;
    }

    public function hasBrandProduct(BrandAwareInterface $product): bool
    {
        return $this->brandProducts->contains($product);
    }

    public function addBrandProduct(BrandAwareInterface $product): void
    {
        if (!$this->hasBrandProduct($product)) {
            $product->setBrand($this);
            $this->brandProducts->add($product);
        }
    }

    public function removeBrandProduct(BrandAwareInterface $product): void
    {
        if ($this->hasBrandProduct($product)) {
            $product->setBrand(null);
            $this->brandProducts->removeElement($product);
        }
    }
}
