<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Model;

use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\TaxonInterface;

trait BrandAwareTrait
{
    /**
     * @var TaxonInterface
     *
     * @ORM\ManyToOne(targetEntity="\Dedi\SyliusTaxonTypePlugin\Model\TypedTaxonInterface", cascade={"persist"},  inversedBy="brandProducts")
     *
     * @ORM\JoinColumn(name="brand_id", referencedColumnName="id", onDelete="SET NULL")
     */
    protected $brand;

    public function getBrand(): ?TaxonInterface
    {
        return $this->brand;
    }

    public function setBrand(?TaxonInterface $brand): self
    {
        $this->brand = $brand;

        return $this;
    }
}
