<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Form\Extension;

use Dedi\SyliusTaxonTypePlugin\Form\Type\BrandAutocompleteChoiceType;
use Dedi\SyliusTaxonTypePlugin\Model\BrandAwareInterface;
use Dedi\SyliusTaxonTypePlugin\Model\TypedTaxonInterface;
use Sylius\Bundle\ProductBundle\Form\Type\ProductType;
use Sylius\Component\Core\Model\ProductInterface;
use Sylius\Component\Core\Model\ProductTaxonInterface;
use Sylius\Component\Resource\Factory\FactoryInterface;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;

class BrandAwareProductTypeExtension extends AbstractTypeExtension
{
    private readonly FactoryInterface $productTaxonFactory;

    public function __construct(FactoryInterface $productTaxonFactory)
    {
        $this->productTaxonFactory = $productTaxonFactory;
    }

    /**
     * @inheritdoc
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('brand', BrandAutocompleteChoiceType::class, [
                'label' => 'dedi_sylius_taxon_type_plugin.ui.brand',
                'required' => false,
            ])
            ->addEventListener(FormEvents::SUBMIT, function (FormEvent $event): void {
                /** @var BrandAwareInterface|ProductInterface $product */
                $product = $event->getData();

                $existingBrand = null;
                foreach ($product->getProductTaxons() as $productTaxon) {
                    /** @var TypedTaxonInterface $taxon */
                    $taxon = $productTaxon->getTaxon();
                    if ($taxon->getType() === TypedTaxonInterface::BRAND_TYPE) {
                        $existingBrand = $productTaxon;

                        break;
                    }
                }

                if (null !== $existingBrand) {
                    if ($existingBrand->getTaxon() === $product->getBrand()) {
                        return;
                    }

                    $product->removeProductTaxon($existingBrand);
                }

                if (null !== $product->getBrand()) {
                    /** @var ProductTaxonInterface $productTaxon */
                    $productTaxon = $this->productTaxonFactory->createNew();
                    $productTaxon->setTaxon($product->getBrand());
                    $product->addProductTaxon($productTaxon);
                }
            })
        ;
    }

    /**
     * @inheritdoc
     */
    public static function getExtendedTypes(): iterable
    {
        return [ProductType::class];
    }
}
