<p>
    <a href="https://sylius.com" target="_blank">
        <img src="https://demo.sylius.com/assets/shop/img/logo.png" />
    </a>
</p>

# Installation
`composer require dedi/sylius-taxon-type-plugin`

Change your `config/bundles.php` file to add these lines for the plugin :

```php
<?php
   
return [
       //..
       Dedi\SyliusTaxonTypePlugin\DediSyliusTaxonTypePlugin::class => ['all' => true],
];
```

Import routing :

```yaml
# config/routes.yaml

# always needed to override default sylius routes
dedi_sylius_taxon_type_admin:
    resource: "@DediSyliusTaxonTypePlugin/Resources/config/routes/default.yaml"
    prefix: /admin
```

```yaml
# config/routes/dedi_sylius_taxon_type_plugin.yaml

# if you need brands
dedi_sylius_taxon_type_admin_brands:
    resource: "@DediSyliusTaxonTypePlugin/Resources/config/routes/brands.yaml"
    prefix: /admin

# if you need selections
dedi_sylius_taxon_type_admin_selections:
    resource: "@DediSyliusTaxonTypePlugin/Resources/config/routes/selections.yaml"
    prefix: /admin
```

Import bundle configuration :

```yaml
# config/packages/dedi_sylius_taxon_type_plugin.yaml

imports:
  # if you need brands
  - { resource: "@DediSyliusTaxonTypePlugin/Resources/config/domain/brands/*" }
  # if you need selections
  - { resource: "@DediSyliusTaxonTypePlugin/Resources/config/domain/selections/*" }
```

In your Taxon class, add the needed interfaces.

`ProductBrandAwareInterface` is needed only if you need brand taxons.

```php
use Dedi\SyliusTaxonTypePlugin\Model\ProductBrandAwareInterface;
use Dedi\SyliusTaxonTypePlugin\Model\ProductBrandAwareTrait;
use Dedi\SyliusTaxonTypePlugin\Model\TypedTaxonInterface;
use Dedi\SyliusTaxonTypePlugin\Model\TypedTaxonTrait;
use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\Taxon as BaseTaxon;

/**
 * @ORM\Entity
 * @ORM\Table(name="sylius_taxon")
 */
class Taxon extends BaseTaxon implements TypedTaxonInterface, ProductBrandAwareInterface
{
    use TypedTaxonTrait;

    use ProductTaxonAwareTrait {
        ProductTaxonAwareTrait::__construct as private __productTaxonAwareTraitConstruct;
    }

    use ProductBrandAwareTrait {
        ProductBrandAwareTrait::__construct as private __productAwareTraitConstruct;
    }

    public function __construct()
    {
        parent::__construct();

        $this->__productAwareTraitConstruct();
        $this->__productTaxonAwareTraitConstruct();
    }
    //...
}
```

In your ProductTaxon model, add the needed AssociationOverride.

```php
use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\ProductTaxon as BaseProductTaxon;

/**
 * @ORM\Entity
 * @ORM\Table(name="sylius_product_taxon")
 * @ORM\AssociationOverrides({
 *      @ORM\AssociationOverride(name="taxon", inversedBy="productTaxons")
 * })
 */
class ProductTaxon extends BaseProductTaxon
{
}
```

Add the needed interfaces and traits to your Taxon repository :

```php
use Dedi\SyliusTaxonTypePlugin\Repository\TypedTaxonRepositoryInterface;
use Dedi\SyliusTaxonTypePlugin\Repository\TypedTaxonRepositoryTrait;
use Sylius\Bundle\TaxonomyBundle\Doctrine\ORM\TaxonRepository as BaseTaxonRepository;

class TaxonRepository extends BaseTaxonRepository implements TypedTaxonRepositoryInterface
{
    use TypedTaxonRepositoryTrait;
}
```

Add the needed interfaces and traits to your Product model :

`BrandAwareInterface` is needed only if you need brand taxons.

`SelectionAwareInterface` is needed only if you need selection taxons.

```php
use Dedi\SyliusTaxonTypePlugin\Model\BrandAwareInterface;
use Dedi\SyliusTaxonTypePlugin\Model\BrandAwareTrait;
use Dedi\SyliusTaxonTypePlugin\Model\SelectionAwareInterface;
use Dedi\SyliusTaxonTypePlugin\Model\SelectionAwareTrait;

class Product extends BaseProduct implements BrandAwareInterface, SelectionAwareInterface
{
    use BrandAwareTrait;

    use SelectionAwareTrait {
        SelectionAwareTrait::__construct as private __selectionAwareConstruct;
    }

    public function __construct()
    {
        parent::__construct();

        $this->__selectionAwareConstruct();
    }
}
```

Add the needed interfaces and traits to your Product repository :

```php
use Dedi\SyliusTaxonTypePlugin\Repository\ProductAutocompleteRepositoryInterface;
use Dedi\SyliusTaxonTypePlugin\Repository\ProductAutocompleteRepositoryTrait;
use Sylius\Bundle\CoreBundle\Doctrine\ORM\ProductRepository as BaseProductRepository;

class ProductRepository extends BaseProductRepository implements ProductAutocompleteRepositoryInterface
{
    use ProductAutocompleteRepositoryTrait;
}
```

Then migrate your database 
```bash
$ bin/console doctrine:migrations:diff
$ bin/console doctrine:migrations:migrate
```

Add type to Taxon admin form:

```twig
{# @SyliusAdminBundle/Taxon/_form.html.twig #}

{{ form_row(form.type) }}
```