<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Repository;

use Doctrine\ORM\QueryBuilder;

trait TypedTaxonRepositoryTrait
{
    public function findAllByType(string $type): QueryBuilder
    {
        return $this->createQueryBuilder('t')
            ->where('t.type = :type')
            ->setParameter('type', $type)
        ;
    }

    public function findRootNodesByType(string $type): array
    {
        return $this->createQueryBuilder('t')
            ->andWhere('t.parent IS NULL')
            ->andWhere('t.type = :type')
            ->setParameter('type', $type)
            ->addOrderBy('t.position')
            ->getQuery()
            ->getResult()
        ;
    }

    public function findByTypeAndPhrase(string $locale, string $type, string $phrase): array
    {
        return $this->createQueryBuilder('t')
            ->innerJoin('t.translations', 'translation', 'WITH', 'translation.locale = :locale')
            ->where('t.type = :type')
            ->andWhere('translation.name LIKE :phrase OR t.code LIKE :phrase')
            ->setParameter('type', $type)
            ->setParameter('phrase', '%' . $phrase . '%')
            ->setParameter('locale', $locale)
            ->getQuery()
            ->getResult()
        ;
    }
}
