<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Model;

use Sylius\Component\Core\Model\TaxonInterface;

interface TypedTaxonInterface extends TaxonInterface
{
    public const BRAND_TYPE = 'brand';

    public const SELECTION_TYPE = 'selection';

    public const DEFAULT_TYPE = 'default';

    public const ALLOWED_TYPES = [
        self::DEFAULT_TYPE,
        self::BRAND_TYPE,
        self::SELECTION_TYPE,
    ];

    public function getType(): string;

    public function setType(string $type): self;

    public static function getAllowedTypes(): array;
}
