<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Model;

use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Model\ProductTaxonInterface;

interface ProductTaxonAwareInterface
{
    public function hasProductTaxons(): bool;

    public function getProductTaxons(): Collection;

    public function hasProductTaxon(ProductTaxonInterface $productTaxon): bool;

    public function addProductTaxon(ProductTaxonInterface $productTaxon): void;

    public function removeProductTaxon(ProductTaxonInterface $productTaxon): void;
}
