<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Grid\Filter;

use Dedi\SyliusTaxonTypePlugin\Model\TypedTaxonInterface;
use Sylius\Component\Grid\Data\DataSourceInterface;
use Sylius\Component\Grid\Filtering\FilterInterface;

class ProductSelectionFilter implements FilterInterface
{
    public function apply(DataSourceInterface $dataSource, string $name, $data, array $options): void
    {
        if ('' === $data[TypedTaxonInterface::SELECTION_TYPE]) {
            return;
        }

        $dataSource->restrict(
            $dataSource
                ->getExpressionBuilder()
                ->equals(
                    'productTaxons.taxon',
                    $data[TypedTaxonInterface::SELECTION_TYPE],
                ),
        );
    }
}
