<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Form\Type\Filter;

use Dedi\SyliusTaxonTypePlugin\Model\TypedTaxonInterface;
use Dedi\SyliusTaxonTypePlugin\Repository\TypedTaxonRepositoryInterface;
use Doctrine\ORM\QueryBuilder;
use Sylius\Component\Core\Model\Taxon;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;

class ProductSelectionFilterType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add(
            TypedTaxonInterface::SELECTION_TYPE,
            EntityType::class,
            [
                'class' => array_key_exists('entity', $options['row_attr']) ? $options['row_attr']['entity'] : Taxon::class,
                'label' => 'dedi_sylius_taxon_type_plugin.ui.selection',
                'placeholder' => 'sylius.ui.all',
                'query_builder' => fn (TypedTaxonRepositoryInterface $taxonRepository): QueryBuilder => $taxonRepository->findAllByType(TypedTaxonInterface::SELECTION_TYPE),
            ],
        );
    }
}
