<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Form\Extension;

use Dedi\SyliusTaxonTypePlugin\Form\Type\TaxonProductAutocompleteChoiceType;
use Dedi\SyliusTaxonTypePlugin\Model\TypedTaxonInterface;
use Sylius\Bundle\TaxonomyBundle\Form\Type\TaxonType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;

final class TaxonTypeExtension extends AbstractTypeExtension
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->addEventListener(FormEvents::POST_SET_DATA, function (FormEvent $event): void {
            $form = $event->getForm();
            $taxon = $event->getData();
            $taxonType = TypedTaxonInterface::DEFAULT_TYPE;

            if ($taxon instanceof TypedTaxonInterface) {
                $taxonType = $taxon->getType();
            }

            $form->add('type', HiddenType::class, [
                'data' => $taxonType,
            ]);

            if ($taxon->getType() === TypedTaxonInterface::SELECTION_TYPE) {
                $form->add('productTaxons', TaxonProductAutocompleteChoiceType::class, [
                    'label' => 'sylius.ui.products',
                    'taxon' => $taxon,
                    'multiple' => true,
                ]);
            }
        });
    }

    public static function getExtendedTypes(): iterable
    {
        return [TaxonType::class];
    }
}
