<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Form\Extension;

use Dedi\SyliusTaxonTypePlugin\Model\SelectionAwareInterface;
use Doctrine\Common\Collections\Collection;
use Sylius\Bundle\CoreBundle\Form\Type\Taxon\ProductTaxonAutocompleteChoiceType;
use Sylius\Bundle\ProductBundle\Form\Type\ProductType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;

class SelectionAwareProductTypeExtension extends AbstractTypeExtension
{
    /**
     * @inheritdoc
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->addEventListener(FormEvents::POST_SET_DATA, function (FormEvent $event): void {
                $product = $event->getData();
                $form = $event->getForm();

                $form->add('selections', ProductTaxonAutocompleteChoiceType::class, [
                    'label' => 'dedi_sylius_taxon_type_plugin.ui.selections',
                    'product' => $product,
                    'multiple' => true,
                    'getter' => fn (SelectionAwareInterface $product): Collection => $product->getProductSelectionTaxons(),
                ]);
            })
            ->addEventListener(FormEvents::SUBMIT, function (FormEvent $event): void {
                $data = $event->getData();

                foreach ($data->getProductSelectionTaxons() as $selection) {
                    $data->removeProductTaxon($selection);
                }
                foreach ($data->getSelections() as $selection) {
                    $data->addProductTaxon($selection);
                }
            })
        ;
    }

    /**
     * @inheritdoc
     */
    public static function getExtendedTypes(): iterable
    {
        return [ProductType::class];
    }
}
