<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Factory;

use Dedi\SyliusTaxonTypePlugin\Model\TypedTaxonInterface;
use Sylius\Component\Taxonomy\Factory\TaxonFactoryInterface;
use Sylius\Component\Taxonomy\Factory\TaxonFactoryInterface as BaseTaxonFactoryInterface;
use Sylius\Component\Taxonomy\Model\TaxonInterface;

class TaxonFactory implements TaxonFactoryInterface, TypedTaxonFactoryInterface
{
    public function __construct(private readonly BaseTaxonFactoryInterface $decoratedFactory)
    {
    }

    public function createNew(): TypedTaxonInterface
    {
        /** @var TypedTaxonInterface $taxon */
        $taxon = $this->decoratedFactory->createNew();
        $taxon->setType(TypedTaxonInterface::DEFAULT_TYPE);

        return $taxon;
    }

    public function createForParent(TaxonInterface $parent): TaxonInterface
    {
        $taxon = $this->createNew();
        $taxon->setParent($parent);

        return $taxon;
    }

    public function createType(string $type): TypedTaxonInterface
    {
        /** @var TypedTaxonInterface $taxon */
        $taxon = $this->decoratedFactory->createNew();
        $taxon->setType($type);

        return $taxon;
    }
}
