const path = require('path');
const Encore = require('@symfony/webpack-encore');
const pluginName = 'shipment';

Encore.reset();

Encore.setOutputPath(`public/build/dedi-plugin/shipment/shop/`)
    .setPublicPath(`/build/dedi-plugin/shipment/shop/`)
    .addEntry(`select_shipping`, path.resolve(__dirname, `./assets/shop/select-shipping/entry.js`))
    .addEntry(`pickup_point_label`, path.resolve(__dirname, `./assets/shop/pickup-point-label/entry.js`))
    .cleanupOutputBeforeBuild()
    .disableSingleRuntimeChunk()
    .enableSourceMaps(!Encore.isProduction())
    .enableSassLoader();

const shopConfig = Encore.getWebpackConfig();
shopConfig.name = `dedi-${pluginName}-shop`;

Encore.reset();

Encore.setOutputPath(`src/Resources/public/build/`)
    .setPublicPath(`/public/build/`)
    .addEntry(`select_shipping`, path.resolve(__dirname, `./assets/shop/select-shipping/entry.js`))
    .addEntry(`pickup_point_label`, path.resolve(__dirname, `./assets/shop/pickup-point-label/entry.js`))
    .cleanupOutputBeforeBuild()
    .disableSingleRuntimeChunk()
    .enableSassLoader();

const distConfig = Encore.getWebpackConfig();
distConfig.name = `dedi-plugin-dist`;

Encore.reset();

module.exports = [shopConfig, distConfig];
