<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Validator\Constraints;

use Symfony\Component\Validator\Constraint;

final class HasPickupPointSelected extends Constraint
{
    public string $pickupPointNotBlank = 'dedi_shipment.shipment.pickup_point.not_blank';

    public function validatedBy(): string
    {
        return 'dedi_shipment_has_pickup_point_selected';
    }

    public function getTargets(): string|array
    {
        return self::CLASS_CONSTRAINT;
    }
}
