<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Repository;

use Dedi\SyliusShipmentPlugin\Entity\PickupPointCode;
use Dedi\SyliusShipmentPlugin\Entity\PickupPointInterface;
use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Resource\Repository\RepositoryInterface;

interface PickupPointRepositoryInterface extends RepositoryInterface
{
    public function findOneByCode(PickupPointCode $code): ?PickupPointInterface;

    /**
     * @psalm-return list<PickupPointInterface>
     */
    public function findByOrder(OrderInterface $order, string $provider): array;
}
