<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Provider\Tnt;

use Dedi\SyliusShipmentPlugin\Formater\OpeningHoursFormaterInterface;

class OpeningHoursFormater implements OpeningHoursFormaterInterface
{
    public function format(array $values): array
    {
        $days = [];

        foreach ($values['openingHours'] as $day => $hours) {
            $days[$day] = $this->getDailyHours($hours);
        }

        return $days;
    }

    private function getDailyHours(array $hours): array
    {
        return [
            'am' => isset($hours['am']) ? str_replace(' ', '', $hours['am']) : null,
            'pm' => isset($hours['pm']) ? str_replace(' ', '', $hours['pm']) : null,
        ];
    }
}
