<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Provider\Tnt;

use Dedi\SyliusShipmentPlugin\Client\ClientInterface;
use SoapClient;
use SoapHeader;
use SoapVar;

class Client implements ClientInterface
{
    public function __construct(private SoapClient $client, private Credentials $credentials)
    {
    }

    public function call(string $method, array $parameters): object
    {
        $this->client->__setSoapHeaders($this->getHeader());

        return $this->client->__soapCall($method, [$parameters], [
            'exceptions' => true,
        ]);
    }

    private function getHeader(): SoapHeader
    {
        $header = sprintf(
            '<wsse:Security xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd">
              <wsse:UsernameToken>
                <wsse:Username>%s</wsse:Username>
                <wsse:Password>%s</wsse:Password>
             </wsse:UsernameToken>
            </wsse:Security>',
            htmlspecialchars($this->credentials->getUsername()),
            htmlspecialchars($this->credentials->getPassword()),
        );

        return new SoapHeader(
            'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd',
            'Security',
            new SoapVar($header, \XSD_ANYXML),
        );
    }
}
