<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Provider;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Dedi\SyliusShipmentPlugin\DependencyInjection\Settings\SettingsInterface;
use Dedi\SyliusShipmentPlugin\Entity\PickupPointCode;
use Dedi\SyliusShipmentPlugin\Entity\PickupPointInterface;
use Dedi\SyliusShipmentPlugin\Repository\PickupPointRepositoryInterface;
use Sylius\Component\Core\Model\OrderInterface;
use Webmozart\Assert\Assert;

class StoreProvider extends Provider implements ProviderInterface
{
    public function __construct(
        private PickupPointRepositoryInterface $pickupPointRepository,
        private SettingsProviderInterface $settingsProvider,
    ) {
    }

    public function isEnabled(): bool
    {
        $settings = $this->settingsProvider->provide();

        Assert::isInstanceOf($settings, SettingsInterface::class);

        return $settings->isStoreEnabled();
    }

    public function getCode(): string
    {
        return 'store';
    }

    public function getName(): string
    {
        return 'store';
    }

    public function findPickupPoints(OrderInterface $order): iterable
    {
        return $this->findAllPickupPoints();
    }

    public function findPickupPoint(PickupPointCode $code): ?PickupPointInterface
    {
        return $this->pickupPointRepository->findOneByCode($code);
    }

    public function findAllPickupPoints(): iterable
    {
        /** @var PickupPointInterface[] $results */
        $results = $this->pickupPointRepository->findBy([
            'code.provider' => $this->getCode(),
        ]);

        return $results;
    }
}
