<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Provider;

use Dedi\SyliusShipmentPlugin\Entity\PickupPointCode;
use Dedi\SyliusShipmentPlugin\Entity\PickupPointInterface;
use Dedi\SyliusShipmentPlugin\Exception\TimeoutException;
use Dedi\SyliusShipmentPlugin\Repository\PickupPointRepositoryInterface;
use Sylius\Component\Core\Model\OrderInterface;

final class LocalProvider extends Provider
{
    public function __construct(
        private ProviderInterface $decoratedProvider,
        private PickupPointRepositoryInterface $pickupPointRepository,
    ) {
    }

    public function findPickupPoints(OrderInterface $order): iterable
    {
        try {
            return $this->decoratedProvider->findPickupPoints($order);
        } catch (TimeoutException) {
            return $this->pickupPointRepository->findByOrder($order, $this->decoratedProvider->getCode());
        }
    }

    public function findPickupPoint(PickupPointCode $code): ?PickupPointInterface
    {
        try {
            return $this->decoratedProvider->findPickupPoint($code);
        } catch (TimeoutException) {
            return $this->pickupPointRepository->findOneByCode($code);
        }
    }

    public function findAllPickupPoints(): iterable
    {
        yield from $this->decoratedProvider->findAllPickupPoints();
    }

    public function getCode(): string
    {
        return $this->decoratedProvider->getCode();
    }

    public function getName(): string
    {
        return $this->decoratedProvider->getName();
    }

    public function isEnabled(): bool
    {
        return $this->decoratedProvider->isEnabled();
    }
}
