<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Provider\Gls;

use Dedi\SyliusShipmentPlugin\Formater\OpeningHoursFormaterInterface;

class OpeningHoursFormater implements OpeningHoursFormaterInterface
{
    public function format(array $values): array
    {
        $days = [];

        foreach ($values['OpeningHours']['Weekday'] as $item) {
            $dayName = mb_strtolower($item['day']);
            $from = \DateTime::createFromFormat('H:i', $item['openAt']['From']);
            $to = \DateTime::createFromFormat('H:i', $item['openAt']['To']);

            $noon = new \DateTime('12:00');

            if ($from < $noon) {
                if ($to > $noon) {
                    $days[$dayName]['am'] = sprintf('%s-%s', $from->format('H:i'), $noon->format('H:i'));
                    $days[$dayName]['pm'] = sprintf('%s-%s', $noon->format('H:i'), $to->format('H:i'));
                } else {
                    $days[$dayName]['am'] = sprintf('%s-%s', $from->format('H:i'), $to->format('H:i'));
                }
            } else {
                $days[$dayName]['pm'] = sprintf('%s-%s', $from->format('H:i'), $to->format('H:i'));
            }
        }

        return $days;
    }
}
