<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Provider\Gls;

use Dedi\SyliusShipmentPlugin\Client\ClientInterface;
use SoapClient;

class Client implements ClientInterface
{
    public function __construct(private SoapClient $client)
    {
    }

    public function call(string $method, array $parameters): object
    {
        return $this->client->__soapCall($method, [$parameters], [
            'exceptions' => true,
        ]);
    }
}
