<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Provider\Dpd;

use Dedi\SyliusShipmentPlugin\Formater\OpeningHoursFormaterInterface;

class OpeningHoursFormater implements OpeningHoursFormaterInterface
{
    public function format(array $values): array
    {
        $days = [];

        foreach ($values['OPENING_HOURS_ITEMS']->OPENING_HOURS_ITEM as $item) {
            $item = (array) $item;
            $dayName = $this->mapDayNumberToName((int) $item['DAY_ID']);
            if (!array_key_exists($dayName, $days)) {
                $days[$dayName]['am'] = sprintf('%s-%s', $item['START_TM'], $item['END_TM']);

                continue;
            }
            $days[$dayName]['pm'] = sprintf('%s-%s', $item['START_TM'], $item['END_TM']);
        }

        return $days;
    }

    private function mapDayNumberToName(int $dayNumber): string
    {
        return match ($dayNumber) {
            1 => self::MONDAY,
            2 => self::TUESDAY,
            3 => self::WEDNESDAY,
            4 => self::THURSDAY,
            5 => self::FRIDAY,
            6 => self::SATURDAY,
            7 => self::SUNDAY,
            default => throw new \InvalidArgumentException('Invalid day number'),
        };
    }
}
