<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Provider\Dpd;

use Dedi\SyliusShipmentPlugin\Client\ClientInterface;
use GuzzleHttp\ClientInterface as HttpClientInterface;

class Client implements ClientInterface
{
    public function __construct(private HttpClientInterface $client, private Credentials $credentials)
    {
    }

    public function call(string $method, array $parameters): object
    {
        $parameters = array_merge([
            'carrier' => $this->credentials->getCarrier(),
            'key' => $this->credentials->getKey(),
        ], $parameters);

        $url = sprintf('%s/%s', $this->credentials->getUrl(), $method);

        return $this->client->request('GET', $url, ['query' => $parameters]);
    }
}
