<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Provider\Colissimo;

use Dedi\SyliusShipmentPlugin\Formater\OpeningHoursFormaterInterface;

class OpeningHoursFormater implements OpeningHoursFormaterInterface
{
    public function format(array $values): array
    {
        return [
            self::MONDAY => $this->getDailyHours($values['horairesOuvertureLundi']),
            self::TUESDAY => $this->getDailyHours($values['horairesOuvertureMardi']),
            self::WEDNESDAY => $this->getDailyHours($values['horairesOuvertureMercredi']),
            self::THURSDAY => $this->getDailyHours($values['horairesOuvertureJeudi']),
            self::FRIDAY => $this->getDailyHours($values['horairesOuvertureVendredi']),
            self::SATURDAY => $this->getDailyHours($values['horairesOuvertureSamedi']),
            self::SUNDAY => $this->getDailyHours($values['horairesOuvertureDimanche']),
        ];
    }

    private function getDailyHours(string $hours): array
    {
        $hours = explode(' ', $hours);

        return [
            'am' => $hours[0] !== '00:00-00:00' ? $hours[0] : null,
            'pm' => $hours[1] !== '00:00-00:00' ? $hours[1] : null,
        ];
    }
}
