<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Provider\Colissimo;

use Dedi\SyliusShipmentPlugin\Client\ClientInterface;
use SoapClient;

class Client implements ClientInterface
{
    public function __construct(private SoapClient $client, private Credentials $credentials)
    {
    }

    public function call(string $method, array $parameters): object
    {
        $parameters = array_merge([
            'accountNumber' => $this->credentials->getAccountNumber(),
            'password' => $this->credentials->getPassword(),
        ], $parameters);

        return $this->client->__soapCall($method, [$parameters], [
            'exceptions' => true,
        ]);
    }
}
