<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Message\Handler;

use Dedi\SyliusShipmentPlugin\Message\Command\LoadPickupPoints;
use Dedi\SyliusShipmentPlugin\Provider\ProviderInterface;
use Dedi\SyliusShipmentPlugin\Repository\PickupPointRepositoryInterface;
use Doctrine\ORM\EntityManagerInterface;
use Sylius\Component\Registry\ServiceRegistryInterface;
use Webmozart\Assert\Assert;

final class LoadPickupPointsHandler
{
    public function __construct(
        private ServiceRegistryInterface $providerRegistry,
        private PickupPointRepositoryInterface $pickupPointRepository,
        private EntityManagerInterface $pickupPointManager,
    ) {
    }

    public function __invoke(LoadPickupPoints $message): void
    {
        /** @var ProviderInterface $provider */
        $provider = $this->providerRegistry->get($message->getProvider());

        $pickupPoints = $provider->findAllPickupPoints();

        $i = 1;

        foreach ($pickupPoints as $pickupPoint) {
            $pickupPointCode = $pickupPoint->getCode();
            Assert::notNull($pickupPointCode);

            $localPickupPoint = $this->pickupPointRepository->findOneByCode($pickupPointCode);

            // if it's found, we will update the properties, else we will just persist this object
            if (null === $localPickupPoint) {
                $this->pickupPointManager->persist($pickupPoint);
            } else {
                $localPickupPoint->setName($pickupPoint->getName());
                $localPickupPoint->setAddress($pickupPoint->getAddress());
                $localPickupPoint->setAddress2($pickupPoint->getAddress2());
                $localPickupPoint->setAddress3($pickupPoint->getAddress3());
                $localPickupPoint->setZipCode($pickupPoint->getZipCode());
                $localPickupPoint->setCity($pickupPoint->getCity());
                $localPickupPoint->setCountry($pickupPoint->getCountry());
                $localPickupPoint->setLatitude($pickupPoint->getLatitude());
                $localPickupPoint->setLongitude($pickupPoint->getLongitude());
            }

            if ($i % 50 === 0) {
                $this->flush();
            }

            ++$i;
        }

        $this->flush();
    }

    private function flush(): void
    {
        $this->pickupPointManager->flush();
        $this->pickupPointManager->clear();
    }
}
