<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Message\Command;

use Dedi\SyliusShipmentPlugin\Provider\ProviderInterface;
use Webmozart\Assert\Assert;

final class LoadPickupPoints implements CommandInterface
{
    private string $provider;

    /**
     * @param mixed|ProviderInterface $provider
     */
    public function __construct($provider)
    {
        if ($provider instanceof ProviderInterface) {
            $provider = $provider->getCode();
        }

        Assert::string($provider);

        $this->provider = $provider;
    }

    public function getProvider(): string
    {
        return $this->provider;
    }
}
