<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class PickupPointIdChoiceType extends AbstractType
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'choice_name' => 'location',
            'choice_value' => 'id',
        ]);
    }

    public function getParent(): string
    {
        return PickupPointChoiceType::class;
    }

    public function getBlockPrefix(): string
    {
        return 'dedi_sylius_shipment_plugin_id_choice';
    }
}
