<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Form\Extension;

use function array_flip;
use Sylius\Bundle\ShippingBundle\Form\Type\ShippingMethodType;
use Sylius\Component\Registry\ServiceRegistryInterface;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;

final class ShippingMethodTypeExtension extends AbstractTypeExtension
{
    public function __construct(private ServiceRegistryInterface $providerRegistry, private array $providers)
    {
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $providers = array_flip($this->providers);

        foreach ($providers as $label => $code) {
            if (!$this->providerRegistry->has($code)) {
                unset($providers[$label]);
            }
        }

        $builder->add('pickupPointProvider', ChoiceType::class, [
            'placeholder' => 'dedi_sylius_shipment_plugin.form.shipping_method.select_pickup_point_provider',
            'label' => 'dedi_sylius_shipment_plugin.form.shipping_method.pickup_point_provider',
            'choices' => $providers,
        ]);
    }

    public static function getExtendedTypes(): iterable
    {
        return [ShippingMethodType::class];
    }
}
