<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Form\Extension;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Dedi\SyliusShipmentPlugin\DependencyInjection\Settings\SettingsInterface;
use Sylius\Bundle\MoneyBundle\Form\Type\MoneyType;
use Sylius\Bundle\ShippingBundle\Form\Type\Calculator\FlatRateConfigurationType;
use Sylius\Bundle\ShippingBundle\Form\Type\Calculator\PerUnitRateConfigurationType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\Range;
use Symfony\Component\Validator\Constraints\Type;
use Webmozart\Assert\Assert;

class ShippingMethodCalculatorTypeExtension extends AbstractTypeExtension
{
    public function __construct(private SettingsProviderInterface $settingsProvider)
    {
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $settings = $this->settingsProvider->provide();

        Assert::isInstanceOf($settings, SettingsInterface::class);

        if (!$settings->isFrancoEnabled()) {
            return;
        }

        $builder
            ->add('franco_amount', MoneyType::class, [
                'label' => 'dedi_sylius_shipment_plugin.form.shipping_method.free_shipping',
                'constraints' => [
                    new Range(['min' => 0, 'minMessage' => 'sylius.shipping_method.calculator.min', 'groups' => ['sylius']]),
                    new Type(['type' => 'integer', 'groups' => ['sylius']]),
                ],
                'currency' => $options['currency'],
                'required' => false,
            ])
        ;
    }

    public static function getExtendedTypes(): iterable
    {
        return [PerUnitRateConfigurationType::class, FlatRateConfigurationType::class];
    }
}
