<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Form\Extension;

use Dedi\SyliusShipmentPlugin\Form\Type\PickupPointIdChoiceType;
use Sylius\Bundle\CoreBundle\Form\Type\Checkout\ShipmentType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\FormBuilderInterface;

final class ShipmentTypeExtension extends AbstractTypeExtension
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('pickupPointId', PickupPointIdChoiceType::class, [
                'label' => 'dedi_sylius_shipment_plugin.form.shipment.pickup_point',
                'placeholder' => 'dedi_sylius_shipment_plugin.form.shipment.select_pickup_point',
                'required' => true,
            ])
        ;
    }

    public static function getExtendedTypes(): iterable
    {
        return [ShipmentType::class];
    }
}
