<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Fixture;

use Sylius\Bundle\CoreBundle\Fixture\AbstractResourceFixture;
use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;

class PickupPointFixture extends AbstractResourceFixture
{
    public function getName(): string
    {
        return 'dedi_sylius_shipment_plugin_pickup_point';
    }

    protected function configureResourceNode(ArrayNodeDefinition $resourceNode): void
    {
        $resourceNode
            ->children()
                ->scalarNode('name')
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->scalarNode('address')
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->scalarNode('address2')
                    ->defaultNull()
                ->end()
                ->scalarNode('address3')
                    ->defaultNull()
                ->end()
                ->scalarNode('zip_code')
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->scalarNode('city')
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->scalarNode('country')
                    ->isRequired()
                    ->cannotBeEmpty()
                ->end()
                ->scalarNode('latitude')
                    ->defaultNull()
                ->end()
                ->scalarNode('longitude')
                    ->defaultNull()
                ->end()
                ->arrayNode('opening_hours')
                    ->scalarPrototype()->end()
                    ->defaultValue([])
                ->end()
                ->arrayNode('code')
                    ->isRequired()
                    ->children()
                        ->scalarNode('id')
                            ->isRequired()
                            ->cannotBeEmpty()
                        ->end()
                        ->scalarNode('provider')
                            ->isRequired()
                            ->cannotBeEmpty()
                        ->end()
                        ->scalarNode('country')
                            ->isRequired()
                            ->cannotBeEmpty()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;
    }
}
