<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Exception;

use Dedi\SyliusShipmentPlugin\Provider\ProviderInterface;
use InvalidArgumentException;
use function sprintf;

final class NonUniqueProviderCodeException extends InvalidArgumentException implements ExceptionInterface
{
    public function __construct(ProviderInterface $provider)
    {
        parent::__construct(sprintf('The code %s is not unique. Found in %s', $provider->getCode(), $provider::class));
    }
}
