<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\EventSubscriber;

use Dedi\SyliusShipmentPlugin\Modifier\OrderAddressModifierInterface;
use Sylius\Component\Core\Model\OrderInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\Workflow\Event\Event;

class CheckoutWorkflowSubscriber implements EventSubscriberInterface
{
    public function __construct(
        private readonly OrderAddressModifierInterface $orderAddressModifier,
    ) {
    }

    public static function getSubscribedEvents(): array
    {
        return [
            'workflow.sylius_order_checkout.completed.select_shipping' => 'afterSelectShipping',
            'workflow.sylius_order_checkout.completed.complete' => 'afterCheckoutComplete',
        ];
    }

    public function afterCheckoutComplete(Event $event): void
    {
        /** @var OrderInterface $order */
        $order = $event->getSubject();
        $this->orderAddressModifier->removeTempAddress($order);
    }

    public function afterSelectShipping(Event $event): void
    {
        /** @var OrderInterface $order */
        $order = $event->getSubject();
        $this->orderAddressModifier->updateOrderShippingAddress($order);
    }
}
