<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Entity;

use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\AddressInterface;

trait TempAddressAwareTrait
{
    #[ORM\OneToOne(targetEntity: AddressInterface::class, cascade: ['ALL'])]
    #[ORM\JoinColumn(name: 'temp_shipping_address_id', referencedColumnName: 'id')]
    private ?AddressInterface $tempShippingAddress = null;

    public function getTempShippingAddress(): ?AddressInterface
    {
        return $this->tempShippingAddress;
    }

    public function setTempShippingAddress(?AddressInterface $tempShippingAddress): static
    {
        $this->tempShippingAddress = $tempShippingAddress;

        return $this;
    }
}
