<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Entity;

use InvalidArgumentException;
use Sylius\Component\Resource\Model\ResourceInterface;

interface PickupPointInterface extends ResourceInterface
{
    public function getCode(): ?PickupPointCode;

    public function setCode(PickupPointCode $code): void;

    public function getCodeValue(): ?string;

    public function getName(): ?string;

    public function setName(string $name): void;

    public function getAddress(): ?string;

    public function setAddress(string $address): void;

    public function getAddress2(): ?string;

    public function setAddress2(string $address2): void;

    public function getAddress3(): ?string;

    public function setAddress3(string $address3): void;

    public function getZipCode(): ?string;

    public function setZipCode(string $zipCode): void;

    public function getCity(): ?string;

    public function setCity(string $city): void;

    /**
     * This is the alpha 2 country code
     */
    public function getCountry(): ?string;

    public function setCountry(string $country): void;

    public function getLatitude(): ?string;

    /**
     * @throws InvalidArgumentException if the $latitude is invalid
     */
    public function setLatitude(?string $latitude): void;

    public function getLongitude(): ?string;

    /**
     * @throws InvalidArgumentException if the $longitude is invalid
     */
    public function setLongitude(?string $longitude): void;

    public function getOpeningHours(): array;

    public function setOpeningHours(array $openingHours): void;

    public function getFullAddress(): string;
}
