<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Entity;

use function sprintf;
use Webmozart\Assert\Assert;

class PickupPoint implements PickupPointInterface
{
    protected ?int $id = null;

    protected ?PickupPointCode $code = null;

    protected ?string $name = null;

    protected ?string $address = null;

    protected ?string $address2 = null;

    protected ?string $address3 = null;

    protected ?string $zipCode = null;

    protected ?string $city = null;

    protected ?string $country = null;

    protected ?string $latitude = null;

    protected ?string $longitude = null;

    protected array $openingHours = [];

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCode(): ?PickupPointCode
    {
        return $this->code;
    }

    public function getCodeValue(): ?string
    {
        return $this->code?->getValue();
    }

    public function setCode(PickupPointCode $code): void
    {
        $this->code = $code;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function getAddress(): ?string
    {
        return $this->address;
    }

    public function setAddress(string $address): void
    {
        $this->address = $address;
    }

    public function getAddress2(): ?string
    {
        return $this->address2;
    }

    public function setAddress2(string $address2): void
    {
        if (strlen($address2) === 0) {
            $address2 = null;
        }
        $this->address2 = $address2;
    }

    public function getAddress3(): ?string
    {
        return $this->address3;
    }

    public function setAddress3(string $address3): void
    {
        if (strlen($address3) === 0) {
            $address3 = null;
        }
        $this->address3 = $address3;
    }

    public function getZipCode(): ?string
    {
        return $this->zipCode;
    }

    public function setZipCode(string $zipCode): void
    {
        $this->zipCode = $zipCode;
    }

    public function getCity(): ?string
    {
        return $this->city;
    }

    public function setCity(string $city): void
    {
        $this->city = $city;
    }

    public function getCountry(): ?string
    {
        return $this->country;
    }

    public function setCountry(string $country): void
    {
        $this->country = $country;
    }

    public function getLatitude(): ?string
    {
        return $this->latitude;
    }

    public function setLatitude(?string $latitude): void
    {
        Assert::nullOrRange((float) $latitude, -90, 90);

        $this->latitude = $latitude;
    }

    public function getLongitude(): ?string
    {
        return $this->longitude;
    }

    public function setLongitude(?string $longitude): void
    {
        Assert::nullOrRange((float) $longitude, -180, 180);

        $this->longitude = $longitude;
    }

    public function getOpeningHours(): array
    {
        return $this->openingHours;
    }

    public function setOpeningHours(array $openingHours): void
    {
        $this->openingHours = $openingHours;
    }

    public function getFullAddress(): string
    {
        return sprintf(
            '%s%s%s, %s %s',
            $this->getAddress(),
            null !== $this->getAddress2() ? ' ' . $this->getAddress2() : '',
            null !== $this->getAddress3() ? ' ' . $this->getAddress3() : '',
            $this->getZipCode(),
            $this->getCity(),
        );
    }
}
