<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Doctrine\ORM;

use Dedi\SyliusShipmentPlugin\Entity\PickupPointCode;
use Dedi\SyliusShipmentPlugin\Entity\PickupPointInterface;
use Dedi\SyliusShipmentPlugin\Repository\PickupPointRepositoryInterface;
use Sylius\Bundle\ResourceBundle\Doctrine\ORM\EntityRepository;
use Sylius\Component\Core\Model\OrderInterface;
use Webmozart\Assert\Assert;

class PickupPointRepository extends EntityRepository implements PickupPointRepositoryInterface
{
    public function findOneByCode(PickupPointCode $code): ?PickupPointInterface
    {
        return $this->createQueryBuilder('o')
            ->andWhere('o.code.id = :codeId')
            ->andWhere('o.code.provider = :codeProvider')
            ->andWhere('o.code.country = :codeCountry')
            ->setParameters([
                'codeId' => $code->getIdPart(),
                'codeProvider' => $code->getProviderPart(),
                'codeCountry' => $code->getCountryPart(),
            ])
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }

    public function findByOrder(OrderInterface $order, string $provider): array
    {
        $shippingAddress = $order->getShippingAddress();
        if (null === $shippingAddress) {
            return [];
        }

        $countryCode = $shippingAddress->getCountryCode();
        if (null === $countryCode) {
            return [];
        }

        $postalCode = $shippingAddress->getPostcode();
        if (null === $postalCode) {
            return [];
        }

        $objs = $this->createQueryBuilder('o')
            ->andWhere('o.code.provider = :provider')
            ->andWhere('o.code.country = :country')
            ->andWhere('o.zipCode = :postalCode')
            ->setParameters([
                'provider' => $provider,
                'country' => $countryCode,
                'postalCode' => $postalCode,
            ])
            ->getQuery()
            ->getResult();

        Assert::allIsInstanceOf($objs, PickupPointInterface::class);
        Assert::isList($objs);

        return $objs;
    }
}
