<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\DependencyInjection\Settings;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;

class SettingsProvider implements SettingsProviderInterface
{
    public function __construct(
        private SettingsInterface $settings,
    ) {
    }

    public function getName(): string
    {
        return 'dedi_shipment_plugin';
    }

    public function provide(bool $default = false): SettingsInterface
    {
        return $this->settings;
    }
}
