<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\DependencyInjection\Settings;

class Settings implements SettingsInterface
{
    public function __construct(
        private bool $enabled,
        private bool $storeEnabled,
        private bool $colissimoEnabled,
        private bool $dpdEnabled,
        private bool $tntEnabled,
        private bool $glsEnabled,
        private bool $francoEnabled,
    ) {
    }

    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    public function isStoreEnabled(): bool
    {
        return $this->storeEnabled;
    }

    public function isColissimoEnabled(): bool
    {
        return $this->colissimoEnabled;
    }

    public function isDpdEnabled(): bool
    {
        return $this->dpdEnabled;
    }

    public function isTntEnabled(): bool
    {
        return $this->tntEnabled;
    }

    public function isGlsEnabled(): bool
    {
        return $this->glsEnabled;
    }

    public function isFrancoEnabled(): bool
    {
        return $this->francoEnabled;
    }
}
