<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\DependencyInjection;

use LogicException;
use Sylius\Bundle\ResourceBundle\DependencyInjection\Extension\AbstractResourceExtension;
use Symfony\Component\Cache\Adapter\AdapterInterface;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;
use Webmozart\Assert\Assert;

final class DediSyliusShipmentExtension extends AbstractResourceExtension
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        /** @psalm-suppress PossiblyNullArgument */
        $config = $this->processConfiguration($this->getConfiguration([], $container), $configs);
        $loader = new XmlFileLoader($container, new FileLocator(__DIR__ . '/../../config'));
        $container->setParameter('dedi_sylius_shipment_plugin.local', $config['local']);

        $this->registerResources('dedi_sylius_shipment_plugin', $config['driver'], $config['resources'], $container);

        $loader->load('services.xml');

        $bundles = $container->hasParameter('kernel.bundles') ? $container->getParameter('kernel.bundles') : [];
        Assert::isArray($bundles);

        $cacheEnabled = $config['cache']['enabled'];
        if ($cacheEnabled) {
            if (!interface_exists(AdapterInterface::class)) {
                throw new LogicException('Using cache is only supported when symfony/cache is installed.');
            }

            if (null === $config['cache']['pool']) {
                throw new LogicException('You should specify pool in order to use cache for pickup point providers.');
            }

            $container->setAlias('dedi_sylius_shipment_plugin.cache', $config['cache']['pool']);
        }

        $container->setParameter('dedi_sylius_shipment_plugin.cache.enabled', $cacheEnabled);

        if ($config['providers']['faker']) {
            if ('prod' === $container->getParameter('kernel.environment')) {
                throw new LogicException("You can't use faker provider in production environment.");
            }

            $loader->load('services/providers/faker.xml');
        }

        $container->setParameter('dedi_sylius_shipment_plugin.credentials.colissimo.wsdl', $config['providers']['colissimo']['wsdl']);
        $container->setParameter('dedi_sylius_shipment_plugin.credentials.colissimo.account_number', $config['providers']['colissimo']['account_number']);
        $container->setParameter('dedi_sylius_shipment_plugin.credentials.colissimo.password', $config['providers']['colissimo']['password']);
        $loader->load('services/providers/colissimo.xml');

        $container->setParameter('dedi_sylius_shipment_plugin.credentials.dpd.pudo_url', $config['providers']['dpd']['pudo_url']);
        $container->setParameter('dedi_sylius_shipment_plugin.credentials.dpd.carrier', $config['providers']['dpd']['carrier']);
        $container->setParameter('dedi_sylius_shipment_plugin.credentials.dpd.key', $config['providers']['dpd']['key']);
        $loader->load('services/providers/dpd.xml');

        $container->setParameter('dedi_sylius_shipment_plugin.credentials.tnt.wsdl', $config['providers']['tnt']['wsdl']);
        $container->setParameter('dedi_sylius_shipment_plugin.credentials.tnt.username', $config['providers']['tnt']['username']);
        $container->setParameter('dedi_sylius_shipment_plugin.credentials.tnt.password', $config['providers']['tnt']['password']);
        $loader->load('services/providers/tnt.xml');

        $container->setParameter('dedi_sylius_shipment_plugin.credentials.gls.wsdl', $config['providers']['gls']['wsdl']);
        $container->setParameter('dedi_sylius_shipment_plugin.credentials.gls.login', $config['providers']['gls']['login']);
        $container->setParameter('dedi_sylius_shipment_plugin.credentials.gls.password', $config['providers']['gls']['password']);
        $loader->load('services/providers/gls.xml');

        $loader->load('services/providers/store.xml');

        $settingsDefinition = $container->getDefinition('dedi_sylius_shipment_plugin.settings');
        $settingsDefinition->replaceArgument('$enabled', $config['enabled']);
        $settingsDefinition->replaceArgument('$storeEnabled', $config['providers']['store']);
        $settingsDefinition->replaceArgument('$colissimoEnabled', $config['providers']['colissimo']['enabled']);
        $settingsDefinition->replaceArgument('$dpdEnabled', $config['providers']['dpd']['enabled']);
        $settingsDefinition->replaceArgument('$tntEnabled', $config['providers']['tnt']['enabled']);
        $settingsDefinition->replaceArgument('$glsEnabled', $config['providers']['gls']['enabled']);
        $settingsDefinition->replaceArgument('$francoEnabled', $config['franco']['enabled']);
    }
}
