<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\DependencyInjection;

use Dedi\SyliusShipmentPlugin\Doctrine\ORM\PickupPointRepository;
use Dedi\SyliusShipmentPlugin\Entity\PickupPoint;
use Sylius\Bundle\ResourceBundle\Controller\ResourceController;
use Sylius\Bundle\ResourceBundle\Form\Type\DefaultResourceType;
use Sylius\Bundle\ResourceBundle\SyliusResourceBundle;
use Sylius\Component\Resource\Factory\Factory;
use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('dedi_sylius_shipment');
        $rootNode = $treeBuilder->getRootNode();

        /** @psalm-suppress MixedMethodCall,PossiblyUndefinedMethod,PossiblyNullReference */
        $rootNode
            ->addDefaultsIfNotSet()
            ->children()
                ->booleanNode('enabled')->defaultFalse()->end()
                ->scalarNode('driver')->defaultValue(SyliusResourceBundle::DRIVER_DOCTRINE_ORM)->end()
                ->arrayNode('cache')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->booleanNode('enabled')
                            ->defaultFalse()
                        ->end()
                        ->scalarNode('pool')
                            ->defaultNull()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('franco')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->booleanNode('enabled')
                            ->defaultFalse()
                        ->end()
                    ->end()
                ->end()
                ->booleanNode('local')
                    ->defaultValue(true)
                    ->info('Whether to use the local database when timeouts occur in third party HTTP calls. Remember to run the dedi-sylius-shipment-pickup-point:load-pickup-points command periodically to populate the local database with pickup points')
                ->end()
                ->arrayNode('providers')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->booleanNode('faker')
                            ->info('Whether to enable the Faker provider')
                            ->defaultValue(false)
                        ->end()
                        ->arrayNode('colissimo')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->booleanNode('enabled')
                                    ->info('Whether to enable the Colissimo provider')
                                    ->defaultValue(false)
                                ->end()
                                ->scalarNode('wsdl')
                                    ->defaultValue('https://ws.colissimo.fr/pointretrait-ws-cxf/PointRetraitServiceWS/2.0?wsdl')
                                ->end()
                                ->scalarNode('account_number')
                                    ->defaultValue('')
                                ->end()
                                ->scalarNode('password')
                                    ->defaultValue('')
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('dpd')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->booleanNode('enabled')
                                    ->info('Whether to enable the Dpd provider')
                                    ->defaultValue(false)
                                ->end()
                                ->scalarNode('pudo_url')
                                    ->defaultValue('http://mypudo.pickup-services.com/mypudo/mypudo.asmx')
                                ->end()
                                    ->scalarNode('carrier')
                                    ->defaultValue('EXA')
                                ->end()
                                    ->scalarNode('key')
                                    ->defaultValue('')
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('tnt')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->booleanNode('enabled')
                                    ->info('Whether to enable the Tnt provider')
                                    ->defaultValue(false)
                                ->end()
                                ->scalarNode('wsdl')
                                    ->defaultValue('http://www.tnt.fr/service/?wsdl')
                                ->end()
                                    ->scalarNode('username')
                                    ->defaultValue('')
                                ->end()
                                    ->scalarNode('password')
                                    ->defaultValue('')
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('gls')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->booleanNode('enabled')
                                    ->info('Whether to enable the Gls provider')
                                    ->defaultValue(false)
                                ->end()
                                ->scalarNode('wsdl')
                                    ->defaultValue('https://www.gls.dk/webservices_v4/wsShopFinder.asmx?WSDL')
                                ->end()
                                    ->scalarNode('login')
                                    ->defaultValue('')
                                ->end()
                                    ->scalarNode('password')
                                    ->defaultValue('')
                                ->end()
                            ->end()
                        ->end()
                        ->booleanNode('store')
                            ->info('Whether to enable the Store provider')
                            ->defaultValue(false)
                        ->end()
        ;

        $this->addResourcesSection($rootNode);

        return $treeBuilder;
    }

    private function addResourcesSection(ArrayNodeDefinition $node): void
    {
        /** @psalm-suppress MixedMethodCall,PossiblyUndefinedMethod,PossiblyNullReference */
        $node
            ->children()
                ->arrayNode('resources')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->arrayNode('pickup_point')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->variableNode('options')->end()
                                ->arrayNode('classes')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(PickupPoint::class)->cannotBeEmpty()->end()
                                        ->scalarNode('controller')->defaultValue(ResourceController::class)->cannotBeEmpty()->end()
                                        ->scalarNode('repository')->defaultValue(PickupPointRepository::class)->cannotBeEmpty()->end()
                                        ->scalarNode('form')->defaultValue(DefaultResourceType::class)->end()
                                        ->scalarNode('factory')->defaultValue(Factory::class)->end();
    }
}
