<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Controller\Checkout\Order;

use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Core\Model\ShippingMethodInterface;
use Sylius\Component\Core\Repository\ShippingMethodRepositoryInterface;
use Sylius\Component\Order\Context\CartContextInterface;
use Sylius\Component\Order\Processor\OrderProcessorInterface;
use Sylius\Component\Shipping\Model\ShipmentInterface;
use Sylius\TwigHooks\Hook\Renderer\HookRendererInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;

class OrderSummaryUpdater extends AbstractController
{
    /**
     * @param ShippingMethodRepositoryInterface<ShippingMethodInterface> $shippingMethodRepository
     */
    public function __construct(
        private CartContextInterface $cartContext,
        private ShippingMethodRepositoryInterface $shippingMethodRepository,
        private OrderProcessorInterface $orderProcessor,
        private HookRendererInterface $hookRenderer,
    ) {
    }

    public function getOrderSummary(string $code): Response
    {
        /** @var OrderInterface $order * */
        $order = $this->cartContext->getCart();

        /** @var ShipmentInterface|false $shipment */
        $shipment = $order->getShipments()->first();

        /** @var ShippingMethodInterface|null $shippingMethod* */
        $shippingMethod = $this->shippingMethodRepository->findOneBy(['code' => $code]);

        if ($shipment === false) {
            throw $this->createNotFoundException("Order's shipment not found");
        }
        if ($shippingMethod === null) {
            throw $this->createNotFoundException('Shipping Method not found');
        }

        $shipment->setMethod($shippingMethod);
        $this->orderProcessor->process($order);

        return $this->json(
            [
                'view' => $this->hookRenderer->render(
                    ['sylius_shop.checkout.common.sidebar'],
                    ['order' => $order],
                ),
            ],
        );
    }
}
