<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Controller\Action;

use Dedi\SyliusShipmentPlugin\Entity\PickupPointInterface;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\Serializer\SerializerInterface;

final class PickupPointByIdAction
{
    /**
     * @param DataTransformerInterface<PickupPointInterface|null, string|null> $pickupPointToIdentifierTransformer
     */
    public function __construct(
        private SerializerInterface $serializer,
        private DataTransformerInterface $pickupPointToIdentifierTransformer,
    ) {
    }

    public function __invoke(Request $request): Response
    {
        $pickupPointId = $request->query->getString('pickupPointId');
        if ('' === $pickupPointId) {
            throw new NotFoundHttpException();
        }

        /** @var PickupPointInterface|mixed $pickupPoint */
        $pickupPoint = $this->pickupPointToIdentifierTransformer->reverseTransform($pickupPointId);
        if (!$pickupPoint instanceof PickupPointInterface) {
            throw new NotFoundHttpException();
        }

        $pickupPoint = $this->serializer->serialize($pickupPoint, 'json', ['groups' => ['Detailed'], 'iri' => false]);

        return new JsonResponse($pickupPoint, Response::HTTP_OK);
    }
}
