<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\CartProvider;

use Dedi\SyliusShipmentPlugin\Entity\TempAddressAwareInterface;
use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Core\Repository\OrderRepositoryInterface;
use Sylius\Component\Order\Context\CartContextInterface;
use Webmozart\Assert\Assert;

class CartForAddressingProvider implements CartForAddressingProviderInterface
{
    /**
     * @param OrderRepositoryInterface<OrderInterface> $orderRepository
     */
    public function __construct(
        private CartContextInterface $cartContext,
        private OrderRepositoryInterface $orderRepository,
    ) {
    }

    public function provide(): ?OrderInterface
    {
        $id = $this->cartContext->getCart()->getId();

        /** @var OrderInterface|null $order */
        $order = $this->orderRepository->findCartForAddressing($id);

        if (null === $order) {
            return null;
        }

        Assert::isInstanceOf($order, TempAddressAwareInterface::class);

        if (null === $order->getTempShippingAddress()) {
            return $order;
        }

        $order->setShippingAddress($order->getTempShippingAddress());

        return $order;
    }
}
