<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Calculator;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Dedi\SyliusShipmentPlugin\DependencyInjection\Settings\SettingsInterface;
use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Core\Model\ShipmentInterface;
use Sylius\Component\Shipping\Calculator\CalculatorInterface;
use Sylius\Component\Shipping\Model\ShipmentInterface as BaseShipmentInterface;
use Webmozart\Assert\Assert;

class ShippingMethodWithFrancoCalculator implements CalculatorInterface
{
    public function __construct(
        private CalculatorInterface $decoratedCalculator,
        private SettingsProviderInterface $settingsProvider,
    ) {
    }

    public function calculate(BaseShipmentInterface $subject, array $configuration): int
    {
        $defaultAmount = $this->decoratedCalculator->calculate($subject, $configuration);

        $settings = $this->settingsProvider->provide();

        Assert::isInstanceOf($settings, SettingsInterface::class);

        if (!$settings->isFrancoEnabled()) {
            return $defaultAmount;
        }

        Assert::isInstanceOf($subject, ShipmentInterface::class);

        $order = $subject->getOrder();

        Assert::isInstanceOf($subject, OrderInterface::class);

        $channelCode = $order->getChannel()->getCode();

        if (isset($configuration[$channelCode]['franco_amount']) &&
            $configuration[$channelCode]['franco_amount'] <= ($order->getTotal() - $order->getShippingTotal())
        ) {
            return 0;
        }

        return $defaultAmount;
    }

    public function getType(): string
    {
        return $this->decoratedCalculator->getType();
    }
}
