<?php

declare(strict_types=1);

namespace Dedi\SyliusShipmentPlugin\Address;

use Dedi\SyliusShipmentPlugin\Entity\PickupPointAwareInterface;
use Sylius\Component\Core\Customer\CustomerAddressAdderInterface;
use Sylius\Component\Core\Customer\OrderAddressesSaverInterface;
use Sylius\Component\Core\Model\AddressInterface;
use Sylius\Component\Core\Model\CustomerInterface;
use Sylius\Component\Core\Model\OrderInterface;

class CustomerOrderAddressesSaver implements OrderAddressesSaverInterface
{
    public function __construct(
        private CustomerAddressAdderInterface $addressAdder,
    ) {
    }

    public function saveAddresses(OrderInterface $order): void
    {
        /** @var CustomerInterface $customer */
        $customer = $order->getCustomer();
        if (null === $customer->getUser()) {
            return;
        }

        $this->addAddress($customer, $order->getBillingAddress());
        $shipment = $order->getShipments()->first();
        if (!$shipment instanceof PickupPointAwareInterface || !$shipment->hasPickupPointId()) {
            $this->addAddress($customer, $order->getShippingAddress());
        }
    }

    private function addAddress(CustomerInterface $customer, ?AddressInterface $address): void
    {
        if (null !== $address) {
            $this->addressAdder->add($customer, clone $address);
        }
    }
}
