<?php

declare(strict_types=1);

use Rector\Config\RectorConfig;
use Rector\Set\ValueObject\SetList;

return static function (RectorConfig $containerConfigurator): void {
    // get parameters
    $containerConfigurator->paths([
            __DIR__ . '/src',
            __DIR__ . '/tests/Application/src',
        ]
    );

    // Define what rule sets will be applied
    $containerConfigurator->import(SetList::PHP_80);

    $containerConfigurator->importNames();
    $containerConfigurator->importShortClasses();
};
